/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.init.ModBlocks;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.tileentity.AirdropTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.NetworkHooks;

public class AirdropEntity
extends Entity {
    private static final Vector3d FALL_VEC = new Vector3d(0.0, -0.1, 0.0);

    public AirdropEntity(World world) {
        this((EntityType)ModEntities.AIRDROP.get(), world);
    }

    public AirdropEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        FluidState fluidState;
        BlockPos pos = this.func_233580_cy_();
        this.func_213317_d(FALL_VEC);
        if (this.field_70124_G) {
            this.placeOnGround(pos, false);
        }
        if (!(fluidState = this.field_70170_p.func_204610_c(pos)).func_206888_e()) {
            this.placeOnGround(pos, true);
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    private void placeOnGround(BlockPos pos, boolean forcePlacement) {
        BlockPos landingPosition;
        if (forcePlacement) {
            landingPosition = pos;
        } else {
            int y = this.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p());
            landingPosition = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }
        if (!this.field_70170_p.func_175623_d(landingPosition)) {
            this.field_70170_p.func_175655_b(landingPosition, true);
        }
        this.func_70106_y();
        this.field_70170_p.func_180501_a(landingPosition, ModBlocks.AIRDROP.func_176223_P(), 3);
        TileEntity tileEntity = this.field_70170_p.func_175625_s(landingPosition);
        if (!(tileEntity instanceof AirdropTileEntity)) {
            GunsRPG.log.error("Unexpected block entity type at {} from {}", (Object)landingPosition, (Object)this);
            return;
        }
        ((AirdropTileEntity)tileEntity).generateLoot();
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
    }
}

